#pragma once

#include "sidecars_system_logs_filter.h"

#include <util/generic/string.h>

namespace NInfra::NPodAgent {

class TSidecarsSystemLogsFilterImpl: public ISidecarsSystemLogsFilter {
public:
    static const constexpr char* LOGBROKER_BOX_ID = "logbroker-tools-box";
    static const constexpr char* LOGBROKER_BOX_UNDERSCORED_ID = "logbroker_tools_box";
    static const constexpr char* LOGBROKER_UNIFIED_AGENT_WORKLOAD_ID = "logbroker_push_agent_workload";
    static const constexpr char* LOGBROKER_MONITOR_WORKLOAD_ID = "logbroker_monitor_workload";
    static const constexpr char* TVM_BOX_ID = "tvm-box";
    static const constexpr char* TVM_BOX_UNDERSCORED_ID = "tvm_box";
    static const constexpr char* DRU_WORKLOAD_ID_POSTFIX = "_dru";
    static const constexpr char* JUGGLER_WORKLOAD_ID_POSTFIX = "-juggler-workload";
    static const constexpr char* LOGROTATE_WORKLOAD_ID_PREFIX = "logrotate_";

public:
    TSidecarsSystemLogsFilterImpl()
    {
    }

    virtual ~TSidecarsSystemLogsFilterImpl() = default;

    virtual bool DropMessageFrom(const TString& objectId) const override;
};

} // namespace NInfra::NPodAgent
