#include "sidecars_system_logs_filter_impl.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestSidecarsSystemLogsFilter {

Y_UNIT_TEST_SUITE(SidecarsSystemLogsFilterSuite) {

Y_UNIT_TEST(TestSidecarsSystemLogsFilter) {
    TString myBoxId = "my_box";

    TSidecarsSystemLogsFilterPtr sidecarsSystemLogsFilter = new TSidecarsSystemLogsFilterImpl();
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom(TSidecarsSystemLogsFilterImpl::LOGBROKER_BOX_ID), true);
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom(TSidecarsSystemLogsFilterImpl::LOGBROKER_BOX_UNDERSCORED_ID), true);
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom(TSidecarsSystemLogsFilterImpl::LOGBROKER_UNIFIED_AGENT_WORKLOAD_ID), true);
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom(TSidecarsSystemLogsFilterImpl::LOGBROKER_MONITOR_WORKLOAD_ID), true);
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom(TSidecarsSystemLogsFilterImpl::TVM_BOX_ID), true);
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom(TSidecarsSystemLogsFilterImpl::TVM_BOX_UNDERSCORED_ID), true);
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom(myBoxId + TSidecarsSystemLogsFilterImpl::DRU_WORKLOAD_ID_POSTFIX), true);
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom(myBoxId + TSidecarsSystemLogsFilterImpl::JUGGLER_WORKLOAD_ID_POSTFIX), true);
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom(TSidecarsSystemLogsFilterImpl::LOGROTATE_WORKLOAD_ID_PREFIX + myBoxId), true);
    UNIT_ASSERT_EQUAL(sidecarsSystemLogsFilter->DropMessageFrom("my_object_id"), false);
}

}

} // namespace NInfra::NPodAgent::NTestSystemLogsSender
