#pragma once

#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class TSystemLogsStatistics;
using TSystemLogsStatisticsPtr = TIntrusivePtr<TSystemLogsStatistics>;

class TSystemLogsStatistics : public TAtomicRefCount<TSystemLogsStatistics> {
public:
    TSystemLogsStatistics()
        : NumBytesSent_{0}
        , NumBytesDropped_{0}
    {}

    void AddNumBytesSent(i64 numOfBytes) {
        AtomicAdd(NumBytesSent_, numOfBytes);
    }

    i64 GetNumBytesSent() const {
        return AtomicGet(NumBytesSent_);
    }

    void AddNumBytesDropped(i64 numOfBytes) {
        AtomicAdd(NumBytesDropped_, numOfBytes);
    }

    i64 GetNumBytesDropped() const {
        return AtomicGet(NumBytesDropped_);
    }

    void Reset() {
        AtomicSet(NumBytesSent_, 0);
        AtomicSet(NumBytesDropped_, 0);
    }

private:
    TAtomic NumBytesSent_;
    TAtomic NumBytesDropped_;
};

} //namespace NInfra::NPodAgent
