#pragma once

#include "system_logs_statistics.h"
#include "system_logs_statistics_printer.h"

#include <infra/libs/logger/log_frame.h>

#include <infra/pod_agent/libs/multi_unistat/multi_unistat.h>
#include <infra/pod_agent/libs/system_logs_sender/system_logs_session_collection.h>

#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class TSystemLogsStatisticsPrinter: public ISystemLogsStatisticsPrinter {
public:
    TSystemLogsStatisticsPrinter(
        TSystemLogsStatisticsPtr statistics
        , TSystemLogsSessionCollectionPtr boxSystemLogSessionCollection
        , TSystemLogsSessionCollectionPtr workloadSystemLogSessionCollection
        , TLogFramePtr logFrame
        , ui32 printPeriodSec
    );

    void Print() override;

public:
    static const size_t SYSTEM_LOGS_PRINTER_DEFAULT_PRINT_PERIOD_SEC = 5;

private:
    static constexpr const char* COUNTER_TRANSFERED_LOGS_BYTES = "pod_agent_system_logs_transfered_bytes";
    static constexpr const char* COUNTER_DROPPED_LOGS_BYTES = "pod_agent_system_logs_dropped_bytes";
    static constexpr const char* COUNTER_NUM_OF_SYSTEM_LOGS_ENABLED_BOX_SESSIONS = "pod_agent_system_logs_num_of_enabled_box_sessions";
    static constexpr const char* COUNTER_NUM_OF_SYSTEM_LOGS_DISABLED_BOX_SESSIONS = "pod_agent_system_logs_num_of_disabled_box_sessions";
    static constexpr const char* COUNTER_NUM_OF_SYSTEM_LOGS_ENABLED_WORKLOAD_SESSIONS = "pod_agent_system_logs_num_of_enabled_workload_sessions";
    static constexpr const char* COUNTER_NUM_OF_SYSTEM_LOGS_DISABLED_WORKLOAD_SESSIONS = "pod_agent_system_logs_num_of_disabled_workload_sessions";

private:
    void InitSignals();
    void SendSignal(const TString& signalType, i64 value);

private:
    ui64 LastPrintTime_;
    TSystemLogsStatisticsPtr Statistics_;
    TSystemLogsSessionCollectionPtr BoxSystemLogsSessionCollection_;
    TSystemLogsSessionCollectionPtr WorkloadSystemLogsSessionCollection_;
    TLogFramePtr LogFrame_;
    ui32 PrintPeriodSec_;

    static bool IsInitialized_;
    static TRWMutex SignalMutex_;
};

} //namespace NInfra::NPodAgent
