#include "system_logs_statistics_printer_impl.h"

#include <infra/libs/logger/logger.h>
#include <infra/pod_agent/libs/system_logs_sender/system_logs_session_collection_mock.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NLogsTransmitterStatisticsPrinterTest {

static TLogger logger({});

struct TTestSystemLogsSessionCollection : public TMockSystemLogsSessionCollection {
    size_t GetEnabledSessionsCount() const override { return EnabledSessionsCount_; }
    size_t GetDisabledSessionsCount() const override { return DisabledSessionsCount_; }

    size_t EnabledSessionsCount_ = 10;
    size_t DisabledSessionsCount_ = 11;
};

Y_UNIT_TEST_SUITE(SystemLogsStatisticsPrinterSuite) {

Y_UNIT_TEST(PrintStatisticsAfterPeriodOk) {

    TMultiUnistat::Instance().Reset(TMultiUnistat::ESignalNamespace::INFRA);
    TSystemLogsStatisticsPtr statistics = new TSystemLogsStatistics();

    i64 bytesSent = 5;
    i64 bytesDropped = 6;

    statistics->AddNumBytesSent(bytesSent);
    statistics->AddNumBytesDropped(bytesDropped);

    TSystemLogsSessionCollectionPtr boxSessionCollection = new TTestSystemLogsSessionCollection();
    TSystemLogsSessionCollectionPtr workloadSessionCollection = new TTestSystemLogsSessionCollection();

    ui32 printPeriod = 0;

    TSystemLogsStatisticsPrinterPtr printer = new TSystemLogsStatisticsPrinter(statistics, boxSessionCollection, workloadSessionCollection, logger.SpawnFrame(), printPeriod);

    printer->Print();

    ui32 priority = TMultiUnistat::ESignalPriority::INFRA_INFO;
    TString infoFromUnistat = TMultiUnistat::Instance().CreateInfoDump(TMultiUnistat::ESignalNamespace::INFRA, priority - 1);

    TString holeInfo = TStringBuilder()
        << "{"

        << "\"" << "pod_agent_system_logs_dropped_bytes" << "\":{"
        <<"\"Priority\":" << priority << ","
        <<"\"Value\":6,"
        <<"\"Type\":" << "\"summ" << "\","
        <<"\"Suffix\":\"" << "deee" << "\","
        <<"\"Tags\":\"\"},"

        << "\"" << "pod_agent_system_logs_num_of_disabled_box_sessions" << "\":{"
        <<"\"Priority\":" << priority << ","
        <<"\"Value\":11,"
        <<"\"Type\":" << "\"trnsp" << "\","
        <<"\"Suffix\":\"" << "aeee" << "\","
        <<"\"Tags\":\"\"},"

        << "\"" << "pod_agent_system_logs_num_of_disabled_workload_sessions" << "\":{"
        <<"\"Priority\":" << priority << ","
        <<"\"Value\":11,"
        <<"\"Type\":" << "\"trnsp" << "\","
        <<"\"Suffix\":\"" << "aeee" << "\","
        <<"\"Tags\":\"\"},"

        << "\"" << "pod_agent_system_logs_num_of_enabled_box_sessions" << "\":{"
        <<"\"Priority\":" << priority << ","
        <<"\"Value\":10,"
        <<"\"Type\":" << "\"trnsp" << "\","
        <<"\"Suffix\":\"" << "aeee" << "\","
        <<"\"Tags\":\"\"},"

        << "\"" << "pod_agent_system_logs_num_of_enabled_workload_sessions" << "\":{"
        <<"\"Priority\":" << priority << ","
        <<"\"Value\":10,"
        <<"\"Type\":" << "\"trnsp" << "\","
        <<"\"Suffix\":\"" << "aeee" << "\","
        <<"\"Tags\":\"\"},"

        << "\"" << "pod_agent_system_logs_transfered_bytes" << "\":{"
        <<"\"Priority\":" << priority << ","
        <<"\"Value\":5,"
        <<"\"Type\":" << "\"summ" << "\","
        <<"\"Suffix\":\"" << "deee" << "\","
        <<"\"Tags\":\"\"}"

        << "}";

    UNIT_ASSERT_EQUAL_C(holeInfo, infoFromUnistat, infoFromUnistat);

    UNIT_ASSERT(!statistics->GetNumBytesSent());
    UNIT_ASSERT(!statistics->GetNumBytesDropped());
}

Y_UNIT_TEST(PrintStatisticsBeforePeriodOk) {

    TMultiUnistat::Instance().Reset(TMultiUnistat::ESignalNamespace::INFRA);
    TSystemLogsStatisticsPtr statistics = new TSystemLogsStatistics();

    i64 bytesSent = 5;
    i64 bytesDropped = 6;

    statistics->AddNumBytesSent(bytesSent);
    statistics->AddNumBytesDropped(bytesDropped);

    TSystemLogsSessionCollectionPtr boxSessionCollection = new TTestSystemLogsSessionCollection();
    TSystemLogsSessionCollectionPtr workloadSessionCollection = new TTestSystemLogsSessionCollection();

    ui32 printPeriod = 20;

    TSystemLogsStatisticsPrinterPtr printer = new TSystemLogsStatisticsPrinter(statistics, boxSessionCollection, workloadSessionCollection, logger.SpawnFrame(), printPeriod);

    printer->Print();

    ui32 priority = TMultiUnistat::ESignalPriority::DEBUG;
    TString infoFromUnistat = TMultiUnistat::Instance().CreateInfoDump(TMultiUnistat::ESignalNamespace::INFRA, priority - 1);

    TString holeInfo = TStringBuilder()
        << "{}" ;

    UNIT_ASSERT_EQUAL(holeInfo, infoFromUnistat);

    UNIT_ASSERT_EQUAL(statistics->GetNumBytesSent(), bytesSent);
    UNIT_ASSERT_EQUAL(statistics->GetNumBytesDropped(), bytesDropped);
}

}

}
