#include "system_logs_backend.h"

using namespace NUnifiedAgent;

namespace NInfra::NPodAgent {
    namespace {
        class TClientSessionAdapter: public TLogBackend {
        public:
            explicit TClientSessionAdapter(const TClientSessionPtr& session, THolder<IRecordConverter> recordConverter)
                : Session(session)
                , RecordConverter(std::move(recordConverter))
            {
            }

            void WriteData(const TLogRecord& rec) override {
                Session->Send(RecordConverter->Convert(rec));
            }

            void ReopenLog() override {
            }

        private:
            TClientSessionPtr Session;
            THolder<IRecordConverter> RecordConverter;
        };

        class TSessionHolder {
        protected:
            TSessionHolder(const TClientParameters& parameters, const TSessionParameters& sessionParameters)
                : Client(MakeClient(parameters))
                , Session(Client->CreateSession(sessionParameters))
            {
            }

        protected:
            TClientPtr Client;
            TClientSessionPtr Session;
        };

        class TAgentLogBackend: private TSessionHolder, public TClientSessionAdapter {
        public:
            TAgentLogBackend(
                const TClientParameters& parameters
                , const TSessionParameters& sessionParameters
                , THolder<IRecordConverter> recordConverter
            )
                : TSessionHolder(parameters, sessionParameters)
                , TClientSessionAdapter(TSessionHolder::Session, std::move(recordConverter))
            {
            }

            ~TAgentLogBackend() override {
                TSessionHolder::Session->Close(TInstant::Zero());
            }
        };
    }

    THolder<TLogBackend> MakeSystemLogBackend(
        const TClientParameters& parameters
        , const TSessionParameters& sessionParameters
        , THolder<IRecordConverter> recordConverter
    ) {
        if (!recordConverter) {
            recordConverter = MakeDefaultRecordConverter();
        }
        return MakeHolder<TAgentLogBackend>(parameters, sessionParameters, std::move(recordConverter));
    }
} // namespace NInfra::NPodAgent
