#pragma once

#include "system_logs_sender_types.h"
#include "system_logs_session.h"

#include <infra/libs/outcome/result.h>

#include <library/cpp/threading/future/async.h>

namespace NInfra::NPodAgent {

using NThreading::TFuture;

class ISystemLogsSender;
using ISystemLogsSenderPtr = TIntrusivePtr<ISystemLogsSender>;

class ISystemLogsSender: public TAtomicRefCount<ISystemLogsSender> {
public:

    virtual ~ISystemLogsSender() = default;
    
    virtual void Add(const TString& objectId, TSystemLogsSessionPtr session) = 0;
    virtual void Remove(const TString& objectId) = 0;
    virtual void RemoveAll() = 0;
    virtual bool Has(const TString& objectId) const = 0;
    virtual void MarkEnabled(bool enable) = 0;
    virtual bool GetMarkEnabled() const = 0;
    virtual TFuture<TExpected<void, TSystemLogsSenderError>> SendMessage(const TString& objectId, const TString& message) = 0;
};

} // namespace NInfra::NPodAgent
