#pragma once

#include "sidecars_system_logs_filter_impl.h"
#include "system_logs_sender.h"
#include "system_logs_session_collection.h"

#include <infra/pod_agent/libs/system_logs_sender/statistics/system_logs_statistics.h>

namespace NInfra::NPodAgent {

class TSystemLogsSender;
using TSystemLogsSenderPtr = TIntrusivePtr<TSystemLogsSender>;

class TSystemLogsSender: public ISystemLogsSender {
public:
     TSystemLogsSender(TSystemLogsSessionCollectionPtr sessionCollection
         , TAtomicSharedPtr<IThreadPool> threadPool
         , TSystemLogsStatisticsPtr statistics
         , TSidecarsSystemLogsFilterPtr systemLogsFilter
     )
        : MarkEnabled_(false)
        , ObjectIdToSession_(sessionCollection)
        , ThreadPool_(threadPool)
        , Statistics_(statistics)
        , SystemLogsFilter_(systemLogsFilter)
    {
    }

    virtual ~TSystemLogsSender() = default;
    
    virtual void Add(const TString& objectId, TSystemLogsSessionPtr session) override;
    virtual void Remove(const TString& objectId) override;
    virtual void RemoveAll() override;
    virtual bool Has(const TString& objectId) const override;
    virtual void MarkEnabled(bool enable) override;
    virtual bool GetMarkEnabled() const override;
    virtual TFuture<TExpected<void, TSystemLogsSenderError>> SendMessage(const TString& objectId, const TString& message) override;

private:
    TExpected<void, TSystemLogsSenderError> SendMessageImpl(const TString& objectId, const TString& message);

private:
    TAtomic MarkEnabled_;
    TSystemLogsSessionCollectionPtr ObjectIdToSession_;
    TAtomicSharedPtr<IThreadPool> ThreadPool_;
    TSystemLogsStatisticsPtr Statistics_;
    TSidecarsSystemLogsFilterPtr SystemLogsFilter_;
};

} // namespace NInfra::NPodAgent
