#pragma once

#include <infra/libs/logger/protos/events.ev.pb.h>

#include <util/generic/string.h>
#include <util/string/builder.h>

namespace NInfra::NPodAgent {

struct TSystemLogsSenderError;

} // namespace NInfra::NPodAgent

inline TString ToString(const NInfra::NPodAgent::TSystemLogsSenderError& error);
inline NInfra::NLogEvent::TSystemLogsSenderException ConstructExceptionEvent(const NInfra::NPodAgent::TSystemLogsSenderError& error);

namespace NInfra::NPodAgent {

enum class ESystemLogsSenderError: ui8 {
    Unspecified                   = 0  /* "unspecified" */,
    NoSession                     = 1  /* "no session" */,
    PushSignalError               = 2  /* "metrics signal send error" */
};

struct TSystemLogsSenderError {
    const ESystemLogsSenderError Errno = ESystemLogsSenderError::Unspecified;
    TString Message = "";
};

}

inline TString ToString(const NInfra::NPodAgent::TSystemLogsSenderError& error) {
    return TStringBuilder()
        << error.Errno
        << ':' << error.Message
    ;
}

NInfra::NLogEvent::TSystemLogsSenderException ConstructExceptionEvent(const NInfra::NPodAgent::TSystemLogsSenderError& error) {
    NInfra::NLogEvent::TSystemLogsSenderException ev;
    ev.SetMessage(TStringBuilder()
        << "SystemLogsSenderError:"
        << ToString(error)
    );
    return ev;
}
