#include "mock_system_logs_session.h"
#include "system_logs_session_collection_impl.h"
#include "system_logs_sender_impl.h"
#include "sidecars_system_logs_filter_impl.h"

#include <infra/pod_agent/libs/system_logs_sender/statistics/system_logs_statistics.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/thread.h>

namespace NInfra::NPodAgent::NTestSystemLogsSender {

class TTestSystemLogsSession: public TMockSystemLogsSession
{
public:
    virtual ~TTestSystemLogsSession() = default;

    void MarkEnabled(bool ) override {
        MarkEnabledCalls_++;
    }

    void SendMessage(const TString&) override {
        SendMessageCalls_++;
    }

    int SendMessageCalls_ = 0;
    int MarkEnabledCalls_ = 0;
};

Y_UNIT_TEST_SUITE(SystemLogsSenderSuite) {

Y_UNIT_TEST(TestSystemLogsSenderSendMessage) {
    TAtomicSharedPtr<IThreadPool> threadPool = new TFakeThreadPool();
    TSystemLogsSessionPtr systemLogsSession = new TTestSystemLogsSession();
    TSystemLogsStatisticsPtr statistics = new TSystemLogsStatistics();

    TSystemLogsSessionCollectionPtr sessionCollection = new TSystemLogsSessionCollection();
    TSystemLogsSenderPtr systemLogsSender = new TSystemLogsSender(sessionCollection, threadPool, statistics, new TSidecarsSystemLogsFilterImpl);
    systemLogsSender->Add("object_id_1", systemLogsSession);

    UNIT_ASSERT_EQUAL((bool)(systemLogsSender->SendMessage(TSidecarsSystemLogsFilterImpl::LOGBROKER_BOX_ID, "message").GetValueSync()), true);
    UNIT_ASSERT_EQUAL(((TTestSystemLogsSession*)systemLogsSession.Get())->SendMessageCalls_, 0);
    
    UNIT_ASSERT_EQUAL((bool)(systemLogsSender->SendMessage("object_id_1", "message").GetValueSync()), true);
    UNIT_ASSERT_EQUAL(((TTestSystemLogsSession*)systemLogsSession.Get())->SendMessageCalls_, 1);    

    systemLogsSender->Remove("object_id_1");

    UNIT_ASSERT_EQUAL((bool)(systemLogsSender->SendMessage("object_id_1", "message").GetValueSync()), false);
    UNIT_ASSERT_EQUAL(systemLogsSender->SendMessage("object_id_1", "message").GetValueSync().Error().Errno, ESystemLogsSenderError::NoSession);
}

Y_UNIT_TEST(TestSystemLogsSenderMarkEnabled) {
    TAtomicSharedPtr<IThreadPool> threadPool = new TFakeThreadPool();
    TSystemLogsSessionPtr systemLogsSession1 = new TTestSystemLogsSession();
    TSystemLogsStatisticsPtr statistics = new TSystemLogsStatistics();

    TSystemLogsSessionCollectionPtr sessionCollection = new TSystemLogsSessionCollection();
    TSystemLogsSenderPtr systemLogsSender = new TSystemLogsSender(sessionCollection, threadPool, statistics, new TSidecarsSystemLogsFilterImpl);

    UNIT_ASSERT(!systemLogsSender->Has("object_id_1"));

    systemLogsSender->Add("object_id_1", systemLogsSession1);
    UNIT_ASSERT(systemLogsSender->Has("object_id_1"));
    
    UNIT_ASSERT_EQUAL(((TTestSystemLogsSession*)systemLogsSession1.Get())->MarkEnabledCalls_, 0);

    UNIT_ASSERT(!systemLogsSender->GetMarkEnabled());

    systemLogsSender->MarkEnabled(true);
    UNIT_ASSERT(systemLogsSender->GetMarkEnabled());

    TSystemLogsSessionPtr systemLogsSession2 = new TTestSystemLogsSession();
    systemLogsSender->Add("object_id_2", systemLogsSession2);
    
    UNIT_ASSERT_EQUAL(((TTestSystemLogsSession*)systemLogsSession1.Get())->MarkEnabledCalls_, 1);
    UNIT_ASSERT_EQUAL(((TTestSystemLogsSession*)systemLogsSession2.Get())->MarkEnabledCalls_, 1);

    //Not apply mark enabled to sessions if already applyed
    systemLogsSender->MarkEnabled(true);

    UNIT_ASSERT_EQUAL(((TTestSystemLogsSession*)systemLogsSession1.Get())->MarkEnabledCalls_, 1);
    UNIT_ASSERT_EQUAL(((TTestSystemLogsSession*)systemLogsSession2.Get())->MarkEnabledCalls_, 1);
}

}

} // namespace NInfra::NPodAgent::NTestSystemLogsSender
