#pragma once

#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class ISystemLogsSession;
using TSystemLogsSessionPtr = TIntrusivePtr<ISystemLogsSession>;

class ISystemLogsSession: public TAtomicRefCount<ISystemLogsSession> {
public:
    virtual ~ISystemLogsSession() = default;

    virtual void SendMessage(const TString& message) = 0;
    virtual void MarkEnabled(bool enable) = 0;
    virtual void Disable() = 0;
    virtual bool Enabled() const = 0;
    virtual i64 GetBytesSent() const = 0;
    virtual i64 GetBytesDropped() const = 0;
};

} // namespace NInfra::NPodAgent
