#pragma once

#include "system_logs_sender_types.h"
#include "system_logs_session.h"

#include <infra/libs/outcome/result.h>

#include <util/generic/ptr.h>
#include <util/generic/vector.h>

namespace NInfra::NPodAgent {

class ISystemLogsSessionCollection;
using TSystemLogsSessionCollectionPtr = TIntrusivePtr<ISystemLogsSessionCollection>;

class ISystemLogsSessionCollection: public TAtomicRefCount<ISystemLogsSessionCollection> {
public:

    virtual ~ISystemLogsSessionCollection() = default;

    virtual void Add(const TString& objectId, TSystemLogsSessionPtr) = 0;
    virtual void Remove(const TString& objectId) = 0;
    virtual void RemoveAll() = 0;
    virtual TExpected<TSystemLogsSessionPtr, TSystemLogsSenderError> Get(const TString& objectId) const = 0;
    virtual TVector<TSystemLogsSessionPtr> GetAll() const = 0;
    virtual size_t GetEnabledSessionsCount() const = 0;
    virtual size_t GetDisabledSessionsCount() const = 0;
};

} // namespace NInfra::NPodAgent
