#include "system_logs_session_collection_impl.h"

namespace NInfra::NPodAgent {

void TSystemLogsSessionCollection::Add(const TString& objectId, TSystemLogsSessionPtr session) {
    TWriteGuardBase<TLightRWLock> guard(Lock_);
    ObjectIdToSession_[objectId] = session;
}

void TSystemLogsSessionCollection::Remove(const TString& objectId) {
    TWriteGuardBase<TLightRWLock> guard(Lock_);
    ObjectIdToSession_.erase(objectId);
}

void TSystemLogsSessionCollection::RemoveAll() {
    TWriteGuardBase<TLightRWLock> guard(Lock_);
    ObjectIdToSession_.clear();
}
    
TExpected<TSystemLogsSessionPtr, TSystemLogsSenderError> TSystemLogsSessionCollection::Get(const TString& objectId) const {
    TReadGuardBase<TLightRWLock> guard(Lock_);

    auto result = ObjectIdToSession_.find(objectId);
    
    if (result == ObjectIdToSession_.end()) {
        return TSystemLogsSenderError({ESystemLogsSenderError::NoSession, TStringBuilder() << "no system logs session for object: " << objectId});
    }

    return result->second;
}

TVector<TSystemLogsSessionPtr> TSystemLogsSessionCollection::GetAll() const {
    TReadGuardBase<TLightRWLock> guard(Lock_);

    TVector<TSystemLogsSessionPtr> result;
    
    for(auto const& objectIdToSession: ObjectIdToSession_) {
        result.push_back(objectIdToSession.second);
    }

    return result;
}

size_t TSystemLogsSessionCollection::GetEnabledSessionsCount() const {
    TReadGuardBase<TLightRWLock> guard(Lock_);

    size_t enabledSessionsCount = 0;
    for(auto const& objectIdToSession: ObjectIdToSession_) {
        if (objectIdToSession.second->Enabled()) {
            ++enabledSessionsCount;
        }
    }
    return enabledSessionsCount;
}

size_t TSystemLogsSessionCollection::GetDisabledSessionsCount() const {
    TReadGuardBase<TLightRWLock> guard(Lock_);

    size_t disabledSessionsCount = 0;
    for(auto const& objectIdToSession: ObjectIdToSession_) {
        if (!objectIdToSession.second->Enabled()) {
            ++disabledSessionsCount;
        }
    }
    return disabledSessionsCount;
}

} // namespace NInfra::NPodAgent
