#pragma once

#include "system_logs_session_collection.h"

#include <infra/libs/outcome/result.h>

#include <library/cpp/threading/light_rw_lock/lightrwlock.h>

#include <util/generic/map.h>

namespace NInfra::NPodAgent {

class TSystemLogsSessionCollection: public ISystemLogsSessionCollection {
public:
    void Add(const TString& objectId, TSystemLogsSessionPtr) override;
    void Remove(const TString& objectId) override;
    void RemoveAll() override;
    TExpected<TSystemLogsSessionPtr, TSystemLogsSenderError> Get(const TString& objectId) const override;
    TVector<TSystemLogsSessionPtr> GetAll() const override;
    size_t GetEnabledSessionsCount() const override;
    size_t GetDisabledSessionsCount() const override;

private:
    TLightRWLock Lock_;
    TMap<TString, TSystemLogsSessionPtr> ObjectIdToSession_;
};

} // namespace NInfra::NPodAgent
