#pragma once

#include "system_logs_session_collection.h"

namespace NInfra::NPodAgent {

class TMockSystemLogsSessionCollection: public ISystemLogsSessionCollection {
public:
    TMockSystemLogsSessionCollection() {}

    virtual void Add(const TString&, TSystemLogsSessionPtr) override {}
    virtual void Remove(const TString&) override {}
    virtual void RemoveAll() override {}
    virtual TExpected<TSystemLogsSessionPtr, TSystemLogsSenderError> Get(const TString&) const override { return TExpected<TSystemLogsSessionPtr, TSystemLogsSenderError>::DefaultSuccess(); }
    virtual TVector<TSystemLogsSessionPtr> GetAll() const override { return {}; }
    virtual size_t GetEnabledSessionsCount() const override { return 0; }
    virtual size_t GetDisabledSessionsCount() const override { return 0; }

    virtual ~TMockSystemLogsSessionCollection() = default;
};

} // namespace NInfra::NPodAgent
