#include "mock_system_logs_session.h"
#include "system_logs_session_collection_impl.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/thread.h>

namespace NInfra::NPodAgent::NTestSystemLogsSessionCollection {

Y_UNIT_TEST_SUITE(SystemLogsSessionCollectionSuite) {

Y_UNIT_TEST(TestSessionCollectionAddGetRemove) {
    TSystemLogsSessionPtr systemLogsSession = new TMockSystemLogsSession();
    TSystemLogsSessionCollectionPtr sessionCollection = new TSystemLogsSessionCollection();

    sessionCollection->Add("object_id_1", systemLogsSession);
    sessionCollection->Add("object_id_2", systemLogsSession);

    UNIT_ASSERT_EQUAL((bool)(sessionCollection->Get("object_id_1")), true);
    UNIT_ASSERT_EQUAL(sessionCollection->GetAll().size(), 2);

    sessionCollection->Remove("object_id_1");
    UNIT_ASSERT_EQUAL(sessionCollection->GetAll().size(), 1);
    
    sessionCollection->RemoveAll();
    UNIT_ASSERT_EQUAL(sessionCollection->GetAll().size(), 0);

    UNIT_ASSERT_EQUAL((bool)(sessionCollection->Get("object_id_1")), false);
    UNIT_ASSERT_EQUAL(sessionCollection->Get("object_id_1").Error().Errno, ESystemLogsSenderError::NoSession);
}

}

} // namespace NInfra::NPodAgent::NTestSystemLogsSessionCollection
