#include "system_logs_session_impl.h"

#include "system_logs_backend.h"

namespace NInfra::NPodAgent {

void TSystemLogsSession::SendMessage(const TString& message) {
    if (NeedSwitchState()) {
        SwitchState();
    }

    SendMessageImpl(message);
}
    
void TSystemLogsSession::MarkEnabled(bool enable) {
    AtomicSet(MarkEnabled_, enable);
}

void TSystemLogsSession::Disable() {
    AtomicSet(MarkEnabled_, false);
    Log_ = Nothing();
}

bool TSystemLogsSession::Enabled() const {
    return Log_.Defined();
}

bool TSystemLogsSession::NeedSwitchState() {
    bool markEnabled = AtomicGet(MarkEnabled_);

    if (Log_.Defined() == markEnabled)
        return false;

    return true;
}

void TSystemLogsSession::SwitchState() {
    bool markEnabled = AtomicGet(MarkEnabled_);
    if (markEnabled) {
        auto backend = MakeSystemLogBackend((*Parameters_).GetClientParameters(), (*Parameters_).GetSessionParameters());
        Log_ = MakeHolder<TLog>(std::move(backend));
    } else {
        Log_ = Nothing();
    }
}

void TSystemLogsSession::SendMessageImpl(const TString& message) {
    if (Log_.Defined()) {        
        (*Log_)->Write(ELogPriority::TLOG_INFO, message);
    }
}

i64 TSystemLogsSession::GetBytesSent() const {
    i64 receivedBytes = Counters_->ReceivedBytes.Val();
    Counters_->ReceivedBytes.Sub(receivedBytes);
    return receivedBytes;
}

i64 TSystemLogsSession::GetBytesDropped() const {
    i64 droppedBytes = Counters_->DroppedBytes.Val();
    Counters_->DroppedBytes.Sub(droppedBytes);
    return droppedBytes;
}

TSystemLogsSession::~TSystemLogsSession() {
    try {
        Disable();
    } catch (...) {

    }
}

} // namespace NInfra::NPodAgent
