#pragma once

#include "system_logs_session.h"
#include "system_logs_session_parameters.h"

#include <util/generic/maybe.h>

namespace NInfra::NPodAgent {

class TSystemLogsSession: public ISystemLogsSession {
public:
    TSystemLogsSession(const TString& boxId, const TString& workloadId)
        : MarkEnabled_(false)
        , Counters_(new NUnifiedAgent::TClientSessionCounters())
        , Parameters_(MakeHolder<TSystemLogsSessionParameters>(boxId, workloadId, Counters_))
    {
    }

    virtual ~TSystemLogsSession();

    virtual void SendMessage(const TString& message) override;
    virtual void MarkEnabled(bool enable) override;
    virtual void Disable() override;
    virtual bool Enabled() const override;
    virtual i64 GetBytesSent() const override;
    virtual i64 GetBytesDropped() const override;

private:
    bool NeedSwitchState();
    void SwitchState();
    void SendMessageImpl(const TString& message);

private:
    TAtomic MarkEnabled_;
    TIntrusivePtr<NUnifiedAgent::TClientSessionCounters> Counters_;
    THolder<TSystemLogsSessionParameters> Parameters_;
    TMaybe<THolder<TLog>> Log_;
};

} // namespace NInfra::NPodAgent
