#include "system_logs_session_parameters.h"

#include <util/string/builder.h>

namespace NInfra::NPodAgent {

TSystemLogsSessionParameters::TSystemLogsSessionParameters(
    const TString& boxId
    , const TString& workloadId
    , TIntrusivePtr<NUnifiedAgent::TClientSessionCounters> counters
)
    : ClientParameters_(NUnifiedAgent::TClientParameters(UNIFIED_AGENT_URI))
{
    TLog emptyLog;
    ClientParameters_ = ClientParameters_.SetLog(emptyLog)
                                         .SetSharedSecretKey(STATIC_SECRET)
                                         .SetMaxInflightBytes(MAX_INFLIGHT_BYTES);

    THashMap<TString, TString> metaParameters;
    metaParameters[DEPLOY_BOX_KEY] = boxId;
    metaParameters[DEPLOY_WORKLOAD_KEY] = workloadId;
    metaParameters[DEPLOY_CONTAINER_ID_KEY] = TStringBuilder() << boxId << "/" << workloadId;
    metaParameters[DEPLOY_LOGGER_NAME_KEY] = DEPLOY_LOGGER_NAME_VALUE;
    metaParameters[PARSE_QLOUD_JSON_KEY] = PARSE_QLOUD_JSON_VALUE;
    SessionParameters_.SetMeta(metaParameters);
    SessionParameters_.SetCounters(counters);
}

NUnifiedAgent::TClientParameters TSystemLogsSessionParameters::GetClientParameters() const {
    return ClientParameters_;
}
 
NUnifiedAgent::TSessionParameters TSystemLogsSessionParameters::GetSessionParameters() const {
    return SessionParameters_;
}

} // namespace NInfra::NPodAgent
