#pragma once

#include <logbroker/unified_agent/client/cpp/counters.h>
#include <logbroker/unified_agent/client/cpp/logger/backend.h>

namespace NInfra::NPodAgent {

class TSystemLogsSessionParameters
{
public:
    static const constexpr char* UNIFIED_AGENT_URI = "localhost:12500";
    static const constexpr char* STATIC_SECRET = "STATIC_SECRET";
    static const constexpr char* DEPLOY_BOX_KEY = "deploy_box";
    static const constexpr char* DEPLOY_WORKLOAD_KEY = "deploy_workload";
    static const constexpr char* DEPLOY_CONTAINER_ID_KEY = "deploy_container_id";
    static const constexpr char* DEPLOY_LOGGER_NAME_KEY = "deploy_logger_name";
    static const constexpr char* DEPLOY_LOGGER_NAME_VALUE = "pod_agent_system_logs";
    static const constexpr char* PARSE_QLOUD_JSON_KEY = "parse_qloud_json";
    static const constexpr char* PARSE_QLOUD_JSON_VALUE = "true";

    static const constexpr ui32 MAX_INFLIGHT_BYTES = 50*1024;

    TSystemLogsSessionParameters(
        const TString& boxId
        , const TString& workloadId
        , TIntrusivePtr<NUnifiedAgent::TClientSessionCounters> counters
    );

    NUnifiedAgent::TClientParameters GetClientParameters() const;
    NUnifiedAgent::TSessionParameters GetSessionParameters() const;

private:
    NUnifiedAgent::TClientParameters ClientParameters_;
    NUnifiedAgent::TSessionParameters SessionParameters_;
};

} // namespace NInfra::NPodAgent
