#include "system_logs_session_impl.h"

#include <time.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestSystemLogsSession {

Y_UNIT_TEST_SUITE(SystemLogsSessionSuite) {

long CurrentTimeMilliseconds()
{
  struct timespec t;

  clock_gettime(CLOCK_REALTIME, &t);
  long time = (long)t.tv_sec * 1000 + t.tv_nsec / 1000000;
  return time;
}

Y_UNIT_TEST(TestSessionEnableDisablePerformanceTest) {
    TVector<TSystemLogsSessionPtr> sessions;

    int numOfSessions = 100;
    long maxTimeToEnableDisableSessionsMs = 1000l; //max 10 ms for session enable/disable 

    for(int i = 0; i < numOfSessions; i++) {
        TSystemLogsSessionPtr systemLogsSession = new TSystemLogsSession("box_id", "workload_id");
        sessions.push_back(systemLogsSession);
    }

    for(auto session: sessions) {
        session->MarkEnabled(true);
    }

    long sessionsEnableTime = CurrentTimeMilliseconds();
    for(auto session: sessions) {
        session->SendMessage("message");
    }

    sessionsEnableTime = CurrentTimeMilliseconds() - sessionsEnableTime;
    UNIT_ASSERT_EQUAL(sessionsEnableTime < maxTimeToEnableDisableSessionsMs, true);

    long sessionsDisableTime = CurrentTimeMilliseconds();
    for(auto session: sessions) {
        session->Disable();
    }

    sessionsDisableTime = CurrentTimeMilliseconds() - sessionsDisableTime;
    UNIT_ASSERT_EQUAL(sessionsDisableTime < maxTimeToEnableDisableSessionsMs, true);
}

Y_UNIT_TEST(TestSessionMarkEnabled) {
    TSystemLogsSessionPtr systemLogsSession = new TSystemLogsSession("box_id", "workload_id");

    UNIT_ASSERT_EQUAL(systemLogsSession->Enabled(), false); 
    systemLogsSession->SendMessage("message");
    
    systemLogsSession->MarkEnabled(true);
    UNIT_ASSERT_EQUAL(systemLogsSession->Enabled(), false);    
    
    systemLogsSession->SendMessage("message");
    UNIT_ASSERT_EQUAL(systemLogsSession->Enabled(), true);

    systemLogsSession->MarkEnabled(false);
    UNIT_ASSERT_EQUAL(systemLogsSession->Enabled(), true);

    systemLogsSession->SendMessage("message");
    UNIT_ASSERT_EQUAL(systemLogsSession->Enabled(), false);

    systemLogsSession->MarkEnabled(true);
    UNIT_ASSERT_EQUAL(systemLogsSession->Enabled(), false);    
    
    systemLogsSession->SendMessage("message");
    UNIT_ASSERT_EQUAL(systemLogsSession->Enabled(), true);

    systemLogsSession->Disable();
    UNIT_ASSERT_EQUAL(systemLogsSession->Enabled(), false);
}

}

} // namespace NInfra::NPodAgent::NTestSystemLogsSession
