#include "string_utils.h"

#include <util/stream/str.h>

namespace NInfra::NPodAgent {

TString Wrap(const TString& in, const TString& wrapper) {
    TString prefix = in.StartsWith(wrapper) ? "" : wrapper;
    TString suffix = in.EndsWith(wrapper) ? "" : wrapper;
    return prefix + in + suffix;
}

TString Trim(const TString& source, char ch) {
    size_t first = source.find_first_not_of(ch);
    size_t last  = source.find_last_not_of(ch);

    if (first == TString::npos || last == TString::npos)
        return "";

    return source.substr(first, last - first + 1);
}

TVector<TString> SplitEscaped(const TString& source, char delimiter) {
    TVector<TString> result;
    TStringStream ss;

    auto it = source.begin();
    while (true) {
        if (*it == delimiter || it == source.end()) {
            auto part = Trim(ss.Str());
            if (!part.empty()) {
                result.push_back(part);
            }
            ss.Clear();

            if (it == source.end()) {
                break;
            }
        } else if (*it == '\\' && ((it + 1) != source.end()) && ((*(it + 1) == '\\') || *(it + 1) == delimiter)) {
            ++it;
            ss << *it;
        } else {
            ss << *it;
        }
        ++it;
    }

    return result;
}

} // namespace NInfra::NPodAgent
