#pragma once

#include <util/generic/vector.h>

namespace NInfra::NPodAgent {

TString Wrap(const TString& in, const TString& wrapper);

template <typename T>
TString Quote(const T& in, char quote = '\'');

TString Trim(const TString& source, char ch = ' ');

TVector<TString> SplitEscaped(const TString& source, char delimiter);

} // namespace NInfra::NPodAgent

#define POD_AGENT_STRING_UTILS_INL_H_
#include "string_utils-inl.h"
#undef POD_AGENT_STRING_UTILS_INL_H_
