#include "string_utils.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NStringUtilsTest {

Y_UNIT_TEST_SUITE(StringUtilsSuite) {

Y_UNIT_TEST(TestQuote) {
    UNIT_ASSERT_EQUAL(Quote("aaa"), "'aaa'");
    UNIT_ASSERT_EQUAL(Quote("'aaa"), "'aaa'");
    UNIT_ASSERT_EQUAL(Quote("aaa'"), "'aaa'");
    UNIT_ASSERT_EQUAL(Quote("'aaa'"), "'aaa'");
}

Y_UNIT_TEST(TestTrim) {
    UNIT_ASSERT_EQUAL(Trim("aaa"), "aaa");
    UNIT_ASSERT_EQUAL(Trim("   aaa"), "aaa");
    UNIT_ASSERT_EQUAL(Trim("aaa    "), "aaa");
    UNIT_ASSERT_EQUAL(Trim("   aaa   "), "aaa");
    UNIT_ASSERT_EQUAL(Trim("      "), "");
}

Y_UNIT_TEST(TestSplitEscaped) {
    UNIT_ASSERT_EQUAL(SplitEscaped("a;a;a", ';'), TVector({TString("a"), TString("a"), TString("a")}));
    UNIT_ASSERT_EQUAL(SplitEscaped("a;a;;a", ';'), TVector({TString("a"), TString("a"), TString("a")}));
    UNIT_ASSERT_EQUAL(SplitEscaped("a;a\\;a", ';'), TVector({TString("a"), TString("a;a")}));
    UNIT_ASSERT_EQUAL(SplitEscaped("a;a\\=;a", ';'), TVector({TString("a"), TString("a\\="), TString("a")}));
    UNIT_ASSERT_EQUAL(SplitEscaped("a;a\\\\;a", ';'), TVector({TString("a"), TString("a\\"), TString("a")}));
}

Y_UNIT_TEST(TestWrap) {
    UNIT_ASSERT_EQUAL(Wrap("aaa", "b"), "baaab");
    UNIT_ASSERT_EQUAL(Wrap("baaa", "b"), "baaab");
    UNIT_ASSERT_EQUAL(Wrap("aaab", "b"), "baaab");
    UNIT_ASSERT_EQUAL(Wrap("baaab", "b"), "baaab");
}

}

}