#include <util/stream/file.h>
#include <util/generic/yexception.h>

i32 main(int argc, char* argv[]) {
    if (argc != 3) {
        ythrow yexception() << "Expected 3 aguments, but " << argc << " were provided";
    }

    TFileInput input(argv[1]);
    TString fileContent = input.ReadAll();
    while (fileContent.size()  && (fileContent.back() == ' ' || fileContent.back() == '\n')) {
        fileContent.pop_back();
    }
    for (char& letter : fileContent) {
        if (letter == '\n') {
            letter = ' ';
        }
    }
    const TString intendedFileContent = TString(argv[2]);

    if (fileContent == intendedFileContent) {
        Cerr << "File is correct: '" << fileContent << "'" << Endl;
        return 0;
    } else {
        Cerr << "File content '" << fileContent << "' differs from intended '" << intendedFileContent << "'" << Endl;
        return 1;
    }
}
