import os
import socket
import sys

ITER = 20

def main():
    backbone_ip = os.getenv("DEPLOY_POD_IP_0_ADDRESS")
    fastbone_ip = os.getenv("DEPLOY_POD_IP_1_ADDRESS")

    backbone_cnt = 0
    fastbone_cnt = 0
    box_subnet_0_cnt = 0
    box_subnet_other_cnt = 0
    ips = []
    for i in range(ITER):
        s = socket.socket(socket.AF_INET6, socket.SOCK_STREAM)
        # Qloud-ext balancer
        s.connect(("2a02:6b8:0:3400::4:68", 80))
        ip = s.getsockname()[0]
        ips.append(ip)

        if ip == backbone_ip:
            backbone_cnt += 1
        elif ip == fastbone_ip:
            fastbone_cnt += 1
        elif ip[-2:] == ":0":
            box_subnet_0_cnt += 1
        else:
            box_subnet_other_cnt += 1

        s.close()

    if fastbone_cnt or box_subnet_0_cnt or box_subnet_other_cnt:
        print("We use bad route :(")
        print("backbone_cnt = {}, fastbone_cnt = {}, box_subnet_0_cnt = {}, box_subnet_other_cnt = {}".format(backbone_cnt, fastbone_cnt, box_subnet_0_cnt, box_subnet_other_cnt))
        print("ips (for debug): {}".format(str(ips)))
        sys.exit(1)

    print("All ok, we use only backbone: {}".format(str(ips)))

if __name__ == "__main__":
    main()
