#!/usr/bin/env python3

import requests
import sys
import os


if __name__ == '__main__':
    assert len(sys.argv) >= 3

    oauth_token = os.environ['OAUTH_TOKEN']
    commit_sha = sys.argv[1]
    out_file = sys.argv[2]

    with open(out_file, "wb") as out:
        response = requests.get('https://bb.yandex-team.ru/rest/api/latest/projects/PORTO/repos/porto/archive',
                                params={'format':'tgz',
                                        'at':commit_sha},
                                auth=('x-oauth-token',oauth_token)
        )
        assert response.ok
        out.write(response.content)
