IF (NOT AUTOCHECK)


PACKAGE()
OWNER(g:rtc-sysdev)

DEFAULT(PORTO_VERSION v5.0.9)
DEFAULT(PORTO_RESOURCE 1878200052)
DEFAULT(PORTO_SRC porto-${PORTO_VERSION}.tar.gz)
DEFAULT(PORTO_OUT porto.tar.gz)

DEFAULT(COMMIT_SHA 0)
DEFAULT(BUILD_OPTS --install-deps)
# if COMMIT_SHA is provided:
#     download porto source tree from bitbucket that corresponds to that commit
# else:
#     use PORTO_RESOURCE sandbox resource
IF (COMMIT_SHA)
    PYTHON(
        ./fetch-porto.py ${COMMIT_SHA} ${PORTO_SRC}

        OUT ${PORTO_SRC}
    )
    SET_APPEND(BUILD_OPTS --archive-components=0)
ELSE()
    FROM_SANDBOX(
        FILE ${PORTO_RESOURCE}
        OUT ${PORTO_SRC}
    )
ENDIF()

INCLUDE(${ARCADIA_ROOT}/infra/qemu/vmexec/env.inc)
INCLUDE(${ARCADIA_ROOT}/infra/environments/porto-build-xenial/release/vm-image/env.inc)

PEERDIR(
    ${QEMU_BIN_ROOT}
    ${PORTO_XENIAL_RELEASE_ROOTFS}
)

RUN_PROGRAM(
    infra/qemu/vmexec -S ${ARCADIA_ROOT} -B ${ARCADIA_BUILD_ROOT} -I ${PORTO_XENIAL_RELEASE_ROOTFS}/rootfs.img
                   --vcpu 8 --mem 8G  --  build-porto.py build ${BUILD_OPTS} ${PORTO_SRC} ${PORTO_OUT}
    CWD ${BINDIR}
    IN build-porto.py
       ${PORTO_SRC}
       ${QEMU_BIN_APP}
       ${PORTO_XENIAL_RELEASE_ROOTFS}/rootfs.img

    OUT_NOAUTO ${PORTO_OUT}
    STDOUT_NOAUTO build.log
)
END()


ELSE()
# - if AUTOCHECK then just download built porto resource from sandbox
#
# - to get new PORTO_OUT_RESOURCE (built porto):
#      1) update PORTO_RESOURCE (porto sources) earlier in this file
#      2) launch 'sandbox_built.sh' and copy task id
#      3) wait for task completion
#      4) launch 'get_built_porto_resource_id.sh' with task id as first argument,
#         output will be the new resource id for 'porto.tar.gz'
#      5) replace previous id in DEFAULT(PORTO_OUT_RESOURCE id) with the new one

UNION()
OWNER(g:rtc-sysdev)

DEFAULT(PORTO_OUT_RESOURCE 1878227806)
DEFAULT(PORTO_OUT porto.tar.gz)

FROM_SANDBOX(
    FILE ${PORTO_OUT_RESOURCE}
    RENAME RESOURCE OUT ${PORTO_OUT}
)

END()


ENDIF()
