package main

import (
	"context"
	"fmt"
	"net"
	"os"

	"github.com/golang/protobuf/ptypes/empty"
	"google.golang.org/grpc"

	rpcpb "a.yandex-team.ru/infra/porto/plugins/portostatd/portostatd_rpc"
)

const (
	CtName  = "a"
	CtName2 = "a/b"
	CtName3 = "ct"
)

func main() {
	portostatdConn, err := grpc.DialContext(
		context.Background(),
		"/var/run/portostatd.sock",
		grpc.WithInsecure(),
		grpc.WithContextDialer(func(ctx context.Context, addr string) (net.Conn, error) {
			return net.Dial("unix", addr)
		}),
	)
	if err != nil {
		fmt.Println("Failed to dial server:", err)
		os.Exit(1)
	}

	portostatdClient := rpcpb.NewPortostatdServiceClient(portostatdConn)

	var empty empty.Empty

	// test of 'List()'
	fmt.Println("test of 'List()':")
	list, err := portostatdClient.List(context.Background(), &empty)
	if err != nil {
		fmt.Println("Failed to get list of containers:", err)
		os.Exit(1)
	}

	for i := range list.CtNames {
		fmt.Println(list.CtNames[i])
	}
	fmt.Println()

	// test 'GetCPUUsage()'
	fmt.Println("test of 'GetCPUUsage()':")
	reqCPU := rpcpb.GetCPUStatRequest{CtName: CtName}

	rspCPU, err := portostatdClient.GetCPUUsage(context.Background(), &reqCPU)
	if err != nil {
		fmt.Printf("Failed to get 'cpu_usage' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspCPU)
	fmt.Println()

	// test 'GetCPUUsageSystem()'
	fmt.Println("test of 'GetCPUUsageSystem()':")
	reqCPU = rpcpb.GetCPUStatRequest{CtName: CtName}

	rspCPU, err = portostatdClient.GetCPUUsageSystem(context.Background(), &reqCPU)
	if err != nil {
		fmt.Printf("Failed to get 'cpu_usage_system' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspCPU)
	fmt.Println()

	// test 'GetCPUStats()'
	fmt.Println("test of 'GetCPUStats()':")
	reqCPU = rpcpb.GetCPUStatRequest{CtName: CtName}

	rspCPUStats, err := portostatdClient.GetCPUStats(context.Background(), &reqCPU)
	if err != nil {
		fmt.Printf("Failed to get 'cpu_stats' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspCPUStats)
	fmt.Println()

	// test 'GetMemoryUsage()'
	fmt.Println("test of 'GetMemoryUsage()':")
	reqMemory := rpcpb.GetMemoryStatRequest{CtName: CtName}

	rspMemory, err := portostatdClient.GetMemoryUsage(context.Background(), &reqMemory)
	if err != nil {
		fmt.Printf("Failed to get 'memory_usage' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspMemory)
	fmt.Println()

	// test 'GetMemoryStats()'
	fmt.Println("test of 'GetMemoryStats()':")
	reqMemory = rpcpb.GetMemoryStatRequest{CtName: CtName}

	rspMemoryStats, err := portostatdClient.GetMemoryStats(context.Background(), &reqMemory)
	if err != nil {
		fmt.Printf("Failed to get 'memory_stats' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspMemoryStats)
	fmt.Println()

	// test 'GetIoRead()'
	fmt.Println("test of 'GetIoRead()':")
	reqIo := rpcpb.GetIoStatRequest{CtName: CtName}

	rspIo, err := portostatdClient.GetIoRead(context.Background(), &reqIo)
	if err != nil {
		fmt.Printf("Failed to get 'io_read' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspIo)
	fmt.Println()

	// test 'GetIoWrite()'
	fmt.Println("test of 'GetIoWrite()':")
	reqIo = rpcpb.GetIoStatRequest{CtName: CtName}

	rspIo, err = portostatdClient.GetIoWrite(context.Background(), &reqIo)
	if err != nil {
		fmt.Printf("Failed to get 'io_write' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspIo)
	fmt.Println()

	// test 'GetIoOps()'
	fmt.Println("test of 'GetIoOps()':")
	reqIo = rpcpb.GetIoStatRequest{CtName: CtName}

	rspIo, err = portostatdClient.GetIoOps(context.Background(), &reqIo)
	if err != nil {
		fmt.Printf("Failed to get 'io_ops' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspIo)
	fmt.Println()

	// test 'GetIoTime()'
	fmt.Println("test of 'GetIoTime()':")
	reqIo = rpcpb.GetIoStatRequest{CtName: CtName}

	rspIo, err = portostatdClient.GetIoTime(context.Background(), &reqIo)
	if err != nil {
		fmt.Printf("Failed to get 'io_time' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspIo)
	fmt.Println()

	// test 'GetIoStats()'
	fmt.Println("test of 'GetIoStats()':")
	reqIo = rpcpb.GetIoStatRequest{CtName: CtName}

	rspIoStats, err := portostatdClient.GetIoStats(context.Background(), &reqIo)
	if err != nil {
		fmt.Printf("Failed to get 'io_stats' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspIoStats)
	fmt.Println()

	// test 'GetNetRxBytes()'
	fmt.Println("test of 'GetNetRxBytes()':")
	reqNet := rpcpb.GetNetStatRequest{CtName: CtName}

	rspNet, err := portostatdClient.GetNetRxBytes(context.Background(), &reqNet)
	if err != nil {
		fmt.Printf("Failed to get 'net_rx_bytes' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspNet)
	fmt.Println()

	// test 'GetNetTxBytes()'
	fmt.Println("test of 'GetNetTxBytes()':")
	reqNet = rpcpb.GetNetStatRequest{CtName: CtName}

	rspNet, err = portostatdClient.GetNetTxBytes(context.Background(), &reqNet)
	if err != nil {
		fmt.Printf("Failed to get 'net_tx_bytes' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspNet)
	fmt.Println()

	// test 'GetNetStats()'
	fmt.Println("test of 'GetNetStats()':")
	reqNet = rpcpb.GetNetStatRequest{CtName: CtName}

	rspNetStats, err := portostatdClient.GetNetStats(context.Background(), &reqNet)
	if err != nil {
		fmt.Printf("Failed to get 'net_stats' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspNetStats)
	fmt.Println()

	// test 'GetGpuTemperature()'
	fmt.Println("test of 'GetGpuTemperature()':")
	reqGpu := rpcpb.GetGpuStatRequest{CtName: CtName}

	rspGpu, err := portostatdClient.GetGpuTemperature(context.Background(), &reqGpu)
	if err != nil {
		fmt.Printf("Failed to get 'gpu_temperature' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspGpu)
	fmt.Println()

	// test 'GetGpuUtilization()'
	fmt.Println("test of 'GetGpuUtilization()':")
	reqGpu = rpcpb.GetGpuStatRequest{CtName: CtName}

	rspGpu, err = portostatdClient.GetGpuUtilization(context.Background(), &reqGpu)
	if err != nil {
		fmt.Printf("Failed to get 'gpu_utilization' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspGpu)
	fmt.Println()

	// test 'GetGpuMemoryUtilization()'
	fmt.Println("test of 'GetGpuMemoryUtilization()':")
	reqGpu = rpcpb.GetGpuStatRequest{CtName: CtName}

	rspGpu, err = portostatdClient.GetGpuMemoryUtilization(context.Background(), &reqGpu)
	if err != nil {
		fmt.Printf("Failed to get 'gpu_memory_utilization' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspGpu)
	fmt.Println()

	// test 'GetGpuStats()'
	fmt.Println("test of 'GetGpuStats()':")
	reqGpu = rpcpb.GetGpuStatRequest{CtName: CtName}

	rspGpuStats, err := portostatdClient.GetGpuStats(context.Background(), &reqGpu)
	if err != nil {
		fmt.Printf("Failed to get 'gpu_stats' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspGpuStats)
	fmt.Println()

	// test 'GetBillingStats()'
	fmt.Println("test of 'GetBillingStats()':")
	reqBill := rpcpb.GetBillingStatsRequest{CtNames: []string{CtName, CtName2, CtName3}}

	rspBill, err := portostatdClient.GetBillingStats(context.Background(), &reqBill)
	if err != nil {
		fmt.Printf("Failed to get 'billing_stats' property of '%v' container: %v\n", CtName, err)
		os.Exit(1)
	}

	fmt.Println(rspBill)
	fmt.Println()
}
