package blkio

import (
	"bufio"
	"io"
	"os"
	"strconv"
	"strings"
)

type Device struct {
	Major uint32
	Minor uint32
}

type BlkIOStat map[string]uint64
type BlkIOStatsMap map[Device]BlkIOStat

func FromReader(r io.Reader) (BlkIOStatsMap, error) {
	var operation string
	res := make(BlkIOStatsMap)
	scanner := bufio.NewScanner(r)
	for scanner.Scan() {
		text := scanner.Text()
		fields := strings.Fields(text)
		if len(fields) != 3 {
			// We have reached last 'Total 0' line
			break
		}
		d := strings.Split(fields[0], ":")
		maj, err := strconv.ParseUint(d[0], 10, 64)
		if err != nil {
			return nil, err
		}
		min, err := strconv.ParseUint(d[1], 10, 64)
		if err != nil {
			return nil, err
		}
		device := Device{Major: uint32(maj), Minor: uint32(min)}
		if res[device] == nil {
			res[device] = make(BlkIOStat)
		}
		operation = fields[1]
		value, err := strconv.ParseUint(fields[2], 10, 64)
		if err != nil {
			return nil, err
		}
		res[device][operation] = value
	}
	return res, nil
}

func FromFile(path string) (BlkIOStatsMap, error) {
	f, err := os.Open(path)
	if err != nil {
		return nil, err
	}
	defer f.Close()
	return FromReader(f)
}
