package blkio

import (
	"bytes"
	"reflect"
	"testing"
)

func TestFromReader(t *testing.T) {
	mockServicedBytes := `252:2 Read 10
252:2 Write 20
252:2 Sync 30
252:2 Async 40
252:2 Discard 10
252:2 Total 1000
8:80 Read 5
8:80 Write 15
8:80 Sync 25
8:80 Async 35
8:80 Discard 45
8:80 Total 2000
Total 0
`
	expect := make(BlkIOStatsMap)
	stat252 := make(BlkIOStat)
	stat8 := make(BlkIOStat)

	device252 := Device{Major: 252, Minor: 2}
	stat252["Read"] = 10
	stat252["Write"] = 20
	stat252["Sync"] = 30
	stat252["Async"] = 40
	stat252["Discard"] = 10
	stat252["Total"] = 1000
	expect[device252] = stat252

	device8 := Device{Major: 8, Minor: 80}
	stat8["Read"] = 5
	stat8["Write"] = 15
	stat8["Sync"] = 25
	stat8["Async"] = 35
	stat8["Discard"] = 45
	stat8["Total"] = 2000
	expect[device8] = stat8

	buf := bytes.NewBufferString(mockServicedBytes)
	res, err := FromReader(buf)
	if err != nil {
		t.Errorf("got err: %s", err)
	}
	if !reflect.DeepEqual(res, expect) {
		t.Errorf("result != expected,\nwant:\n%v,\ngot:\n%v", expect, res)
	}

}
