package server

import (
	"context"

	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"

	rpcpb "a.yandex-team.ru/infra/porto/plugins/portostatd/portostatd_rpc"
)

func (s *PortostatdServer) GetBillingStats(ctx context.Context, req *rpcpb.GetBillingStatsRequest) (*rpcpb.GetBillingStatsResponse, error) {
	var (
		reqCPU    rpcpb.GetCPUStatRequest
		reqMemory rpcpb.GetMemoryStatRequest
		reqNet    rpcpb.GetNetStatRequest
	)

	rsp := make([]*rpcpb.GetBillingStatsResponse_ContainerBillingStats, len(req.CtNames))

	for i, ctName := range req.CtNames {
		var billStats rpcpb.GetBillingStatsResponse_BillingStats
		var ctBillStats rpcpb.GetBillingStatsResponse_ContainerBillingStats

		ctBillStats.CtName = ctName
		ctBillStats.CtStats = &billStats

		reqCPU.CtName = ctName
		reqMemory.CtName = ctName
		reqNet.CtName = ctName

		rspCPU, err := getCPUStatCached(&reqCPU, "cpu_usage")
		if err != nil {
			return nil, status.Errorf(codes.Internal, "As a part of getting 'billing_stats', can not get 'cpu_usage' property of '%v' container: %v", ctName, err)
		}
		ctBillStats.CtStats.CpuUsage = rspCPU.Val

		rspCPU, err = getCPUStatCached(&reqCPU, "cpu_usage_system")
		if err != nil {
			return nil, status.Errorf(codes.Internal, "As a part of getting 'billing_stats', can not get 'cpu_usage_system' property of '%v' container: %v", ctName, err)
		}
		ctBillStats.CtStats.CpuUsageSystem = rspCPU.Val

		rspMemory, err := getMemoryStatCached(&reqMemory, "memory_usage")
		if err != nil {
			return nil, status.Errorf(codes.Internal, "As a part of getting 'billing_stats', can not get 'memory_usage' property of '%v' container: %v", ctName, err)
		}
		ctBillStats.CtStats.MemoryUsage = rspMemory.Val

		rspNet, err := getNetStatCached(&reqNet, "net_rx_bytes")
		if err != nil {
			return nil, status.Errorf(codes.Internal, "As a part of getting 'billing_stats', can not get 'net_rx_bytes' property of '%v' container: %v", ctName, err)
		}
		ctBillStats.CtStats.NetRxBytes = rspNet.Val

		rspNet, err = getNetStatCached(&reqNet, "net_tx_bytes")
		if err != nil {
			return nil, status.Errorf(codes.Internal, "As a part of getting 'billing_stats', can not get 'net_tx_bytes' property of '%v' container: %v", ctName, err)
		}
		ctBillStats.CtStats.NetTxBytes = rspNet.Val

		// more to come

		rsp[i] = &ctBillStats
	}

	return &rpcpb.GetBillingStatsResponse{CtsBillStats: rsp}, nil
}
