package iss

import (
	"bytes"

	"github.com/golang/protobuf/jsonpb"
	"github.com/golang/protobuf/proto"
	"go.uber.org/zap"
)

func unmarshalIssResponsePB(data []byte, resp proto.Message) error {
	zap.S().Debugf("Trying to unmarshal")
	reader := bytes.NewReader(data)
	err := jsonpb.Unmarshal(reader, resp)
	if err != nil {
		return err
	}
	return nil
}

func issReqPB(url string, resp proto.Message) error {
	data, err := httpGet(url)
	if err != nil {
		return err
	}
	err = unmarshalIssResponsePB(data, resp)
	if err != nil {
		return err
	}
	return nil
}
