#!/usr/bin/python

import re
import sys

def parse_braces(substr):
    ret = ""
    state = 0
    bal = 0

    if substr == "":
        return ("", -1)

    for i in range(0, len(substr)):
        c = substr[i]
        ret += c

        if (state == 0):
            if c in "{}":
                state = 1
                bal = 1

        elif state == 1:
            if c == "}":
                bal -= 1
            elif c == "{":
                bal += 1

            if (bal == 0):
                return (ret, i)

    return (ret, len(substr))

def split_braces(inp):
    ret = []
    prev = inp
    i = 0

    while i != -1:
        (outer, i) = parse_braces(prev)
        prev = prev[(i + 1):]
        ret += [outer]

    return ret



def parse_description(desc):
    is_v2 = True
    cov = re.search("\{(.*)\}", desc)

    if cov is None:
        return desc

    cov_func_s = cov.groups()[0]
    cov_call = re.search("CovLStrv2\{(.*)\}", cov_func_s)

    if cov_call is None:
        cov_call = re.search("CovLStr\{v1\}(.*)", cov_func_s)
        if cov_call is not None:
            is_v2 = False

    if cov_call is None:
        return desc

    cov_params_s = cov_call.groups()[0]
    toks = split_braces(cov_params_s)
    format = []

    if is_v2:
        args = split_braces(toks[0][1:-1])

        template = ""

        for arg in args:
            m = re.search("t\{(.*)\}", arg)
            if m is not None:
                template = m.groups()[0]
            elif arg != "":
                m = re.search("\{\{code\{(.*)\}\}\}", arg)
                if m is not None:
                    format += ["\"" + m.groups()[0] + "\""]
                else:
                    format += [arg]
    else:
        template = re.search("\{(.*)\}", toks[0]).groups()[0]
        for t in toks[1:]:
            if len(t) > 0:
                unbraced = re.search("\{(.*)\}", t).groups()[0]
                format += [unbraced]

    format = tuple(format)
    if len(format) > 0:
        err_str = template.format(*format)
    else:
        err_str = template

    if is_v2 and len(toks) > 0:
        for t in toks[1:]:
            err_str += " " + t

    return err_str

def parse_event(event, filename):
    line = ""
    tag = ""
    desc_packed = ""

    for field in event:
        if field.tag == "tag":
            tag = field.text
        elif field.tag == "line":
            line = field.text
        elif field.tag == "description":
            desc_packed = field.text

    desc = parse_description(desc_packed)

    print "{}:{}({}) {}".format(filename, line, tag, desc)

if len(sys.argv) != 2:
    print "Wrong arg number"
    sys.exit(0)

FILE = sys.argv[1]

#FILE="./NEGATIVE_RETURNS.errors.xml"

data = open(FILE, "r").read()

from xml.etree.ElementTree import XMLParser

parser = XMLParser()
parser.feed(b'<root>')
parser.feed(data)
parser.feed(b'</root>')
root = parser.close()

err_count = 0

for error in root:
    #single error
    print "Error {}".format(err_count)
    err_count += 1

    filename = ""
    events = []

    for field in error:
        if field.tag == "file":
            filename = field.text
        elif field.tag == "event":
            events += [field]

    for ev in events:
        parse_event(ev, filename)

    print "=======================\n"
