#!/bin/bash -x

cleanup(){

# Cleanup apt
find var/cache/apt/archives -iname '*.deb' -delete || true
find var/lib/apt/lists -type f -delete || true
find var/cache/apt -iname '*.bin' -delete || true

find tmp -mindepth 1 -delete || true

# Reset hostname
: > /etc/hostname

# Reset hosts
cat > /etc/hosts <<EOF
::1          localhost localhost.localdomain localhost6 localhost6.localdomain6
127.0.0.1    localhost localhost.localdomain localhost4 localhost4.localdomain4
EOF

# Link mtab
ln -sf ../proc/self/mounts etc/mtab || true

# Clean rc.conf.local
sed 's/[0-9\.\ ]*//g' -i /etc/rc.conf.local || true

# Cleanup /var/log
find var/log -iname '*.gz' -delete || true
find var/log -iname '*.1' -delete || true
find var/log -type f -print0 | xargs -0 -t tee < /dev/null || true

> root/.bash_history


}

bootstrap(){

CURPATH=`realpath $CUR`
rm ./search-precise.img || true
umount -l chroot || true
rmdir chroot || true
losetup -d /dev/loop0 || true


qemu-img create -f raw ./search-precise.img 2G

modprobe loop

losetup /dev/loop0 ./search-precise.img

parted /dev/loop0 mktable msdos
parted /dev/loop0 mkpart primary ext2 2048s 100%

sleep 1

[[ -w /dev/loop0p1 ]];

mkfs.ext4 -L rootfs /dev/loop0p1

mkdir chroot

mount /dev/loop0p1 chroot

debootstrap --exclude=ubuntu-minimal,resolvconf --arch amd64 precise chroot http://mirror.yandex.ru/ubuntu

cp $CURPATH chroot/$CUR

rm chroot/etc/resolv.conf

tee /etc/hosts <<EOF 
127.0.0.1	localhost
::1		localhost ip6-localhost ip6-loopback
fe00::0		ip6-localnet
ff00::0		ip6-mcastprefix
ff02::1		ip6-allnodes
ff02::2		ip6-allrouters
EOF

portoctl run os virt_mode=os root=`pwd`/chroot net=inherited hostname=localhost
portoctl exec os/script isolate=false command="./$CUR prepare_chroot" cwd=/ user=root hostname=localhost

portoctl destroy os

mount -o bind /dev chroot/dev
mount -o bind /dev/pts chroot/dev/pts

tee chroot/etc/resolv.conf <<EOF
search search.yandex.net yandex.ru
nameserver 2a02:6b8::1:1
nameserver 2a02:6b8:0:3400::1
EOF

chroot chroot "./$CUR" "install_loader"

cd chroot

./$CUR cleanup

cd ..


rm chroot/$CUR

umount -l chroot

losetup -d /dev/loop0
}

prepare_chroot(){

cd /

tee etc/apt/sources.list <<EOF
deb http://mirror.yandex.ru/ubuntu precise main restricted universe multiverse
EOF

tee etc/apt/sources.list.d/yandex-common-temporary.list <<EOF
deb http://common.dist.yandex.ru/common stable/all/
deb http://common.dist.yandex.ru/common stable/amd64/
EOF

locale-gen en_US.UTF-8
locale-gen ru_RU.UTF-8

update-locale LANG=en_US.UTF-8

apt-get update

$APT_GET --force-yes install yandex-archive-keyring yandex-search-common-apt

rm etc/apt/sources.list.d/yandex-common-temporary.list

apt-get update

$APT_GET dist-upgrade

$APT_GET install \
atop \
bc \
binutils \
bsdmainutils \
bzip2 \
curl \
daemon \
dnsutils \
ethtool \
file \
htop \
iptables \
iputils-ping \
language-pack-en \
less \
lockfile-progs \
lsb-release \
lsof \
ltrace \
netbase \
netcat-openbsd \
net-tools \
ntpdate \
psmisc \
python \
rsync \
strace \
traceroute \
vim \
wget \
xz-utils \
cron \
logrotate \
openssh-server \
rsyslog \
sudo \
m4 \
bsd-mailx \
cloud-init

cp /etc/init/tty1.conf /etc/init/ttyS0.conf
sed 's/tty1/ttyS0/g' -i /etc/init/ttyS0.conf

sed 's/disable_root: 1/disable_root: 0/g' -i /etc/cloud/cloud.cfg
sed 's/user: ubuntu/user: root/g' -i /etc/cloud/cloud.cfg

# Time zone: MSK
[ -s usr/share/zoneinfo/Europe/Moscow ] && cp -f usr/share/zoneinfo/Europe/Moscow /etc/localtime
dpkg-reconfigure -f noninteractive tzdata


}

install_loader(){
mount -t proc proc /proc 
mount -t sysfs sysfs /sys

tee etc/default/grub <<EOF
GRUB_DEFAULT=0
GRUB_TIMEOUT=0
GRUB_TIMEOUT_STYLE="menu"
GRUB_CMDLINE_LINUX_DEFAULT="console=ttyS0 console=tty1"
GRUB_CMDLINE_LINUX=""
EOF

tee etc/fstab <<EOF
LABEL=rootfs   /        ext4   defaults        0 0
EOF

$APT_GET install linux-image-virtual grub2

grub-mkconfig -o /boot/grub/grub.cfg

grub-install --modules=part_msdos /dev/loop0

apt-get clean

cleanup

update-initramfs -u -k all

}

export DEBIAN_FRONTEND="noninteractive"
APT_GET="apt-get --yes --no-install-recommends"


CUR=${BASH_SOURCE[0]}

$@
