#!/bin/bash -x

# VM settings

HOST={{ instance.host }}
PORT={{ instance.port }}
LOGIN_PASSWORD="P@ssw0rd"
VCPU_NR=1
MEM="4G"
DISK_SIZE="10G"
HOSTNAME=qemuvm-$HOST-$PORT

# Resources are downloaded into "./data"

# Qemu binaries are dowloaded into ./data/qemu-bin.
# Note: for user net you should use special build of qemu,
# e.g. https://sandbox.yandex-team.ru/resource/308224568
# ask max755 for details

WORKDIR=$PWD"/data/qemu-bin"
IMG_PATH=$PWD"/xenial.img"
CURRENT_PATH=$PWD"/data/current.qcow2"
NETCONF_PATH=$PWD"/data/netconf"

# Unique mac is not neccessary because of isolated L2 domain
VM_MAC="52:54:00:12:34:56"

# Comment to disable VM state drop durint redeploy
VM_REDEPLOY=1

# For tap unset USER_NET below and uncomment below (WIP)
# TAP_NET = 1
# TAP_DEV = "tap$PORT"
# TAP_IP = ""
# TAP_LL based on tap default mac in porto, not available for now
# TAP_LL = ""

USER_NET=1


# When using USER_NET add host instance port forwarding to guest
# Syntax: hostfwd=tcp|udp:[::]:host_porto-[fd00::2]:guest_port
# Max 8 ports available per instance: 6 user + serial + qemu mon

MON_PORT=$PORT # PORT + 0 - for qemu monitor
SERIAL_PORT=$((PORT+1)) # PORTO + 1 - for qemu serial
HOSTFWD+="hostfwd=tcp:[::]:"$((PORT+2))"-[fd00::2]:22," # SSH
HOSTFWD+="hostfwd=tcp:[::]:"$((PORT+3))"-[fd00::2]:80," # HTTP

if [[ -e $NETCONF_PATH ]]; then
    rm -rv $NETCONF_PATH
fi

mkdir $NETCONF_PATH

cat <<EOF > $NETCONF_PATH/meta-data
instance-id: iid-$HOST:$PORT
local-hostname: $HOSTNAME
growpart:
   mode: auto
   devices: ['/']
resize_rootfs: True
EOF

if [[ -v USER_NET ]]; then # User net config

cat <<EOF >> $NETCONF_PATH/meta-data
network-interface: |
    auto eth0
    iface eth0 inet6 static
    address fd00::2/64
    gateway fd00::1
EOF

cat <<EOF > $NETCONF_PATH/network-config
config:
- mac_address: '$VM_MAC'
  name: eth0
  subnets:
  - {address: 'fd00::2/64', gateway: 'fd00::1', type: static, dns_nameservers: ['2a02:6b8:0:3400::1', '2a02:6b8::1:1'], dns_search: ['search.yandex.net']}
  type: physical
version: 1
EOF

    NET="-netdev user,id=qemu_net,ipv6-prefix=fd00::,ipv6-prefixlen=64,ipv6-host=fd00::1,"$HOSTFWD" -device virtio-net-pci,netdev=qemu_net"

    echo "lol"
elif [[ -v TAP_NET ]]; then # TAP config

cat <<EOF >>$NETCONF_PATH/meta-data
 network-interfaces: |
    auto eth0
    iface eth0 inet6 static
    address $TAP_IP/128
    gateway $TAP_LL

EOF

cat <<EOF > $NETCONF_PATH/network-config
config:
- mac_address: '$VM_MAC'
  name: eth0
  subnets:
  - {address: '$TAP_IP/128', gateway: '$TAP_LL',
    type: static}
  type: physical
version: 1
EOF

    NET="-netdev tap,id=qemu_net,ifname=$TAP_DEV,script=no,"
        "-device virtio-net-pci,netdev=qemu_net,mac=$VM_MAC"

fi

cat <<EOF > $NETCONF_PATH/user-data
#cloud-config
password: $LOGIN_PASSWORD
chpasswd: { expire: False }
ssh_pwauth: True

EOF

if [ -r "/dev/kvm" ] && [ -w "/dev/kvm" ]; then
    KVM_FLAG="--enable-kvm"
else
    KVM_FLAG=""
fi

if [[ -v MON_PORT ]]; then
    CHARDEV+="-chardev socket,id=monsk,host=::,port=$MON_PORT,server,nowait -mon monsk -monitor none "
fi

if [[ -v SERIAL_PORT ]]; then
    CHARDEV+="-chardev socket,id=serialsk,host=::,port=$SERIAL_PORT,server,nowait -serial chardev:serialsk "
fi

cd $WORKDIR

if [[ -v VM_REDEPLOY ]] || [ ! -e $CURRENT_PATH ]; then
    rm $CURRENT_PATH
    $WORKDIR/qemu-img create -f qcow2 -b $IMG_PATH $CURRENT_PATH $DISK_SIZE
fi

$WORKDIR/qemu-system-x86_64 \
$KVM_FLAG \
-m "$MEM" -smp "$VCPU_NR" \
-nographic \
-drive file="$CURRENT_PATH",if=virtio,cache=none \
-drive file=fat:"$NETCONF_PATH",if=virtio,file.label=cidata,readonly=on \
$CHARDEV \
$NET
