#include <util/system/yassert.h>
#include <util/stream/output.h>

#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <pwd.h>

int main(int argc, char **argv)
{
    Y_VERIFY(argc > 1, "No shell command given");
    char **exec_argv = argv + 1;

    if (nullptr == getpwuid(getuid()))
    {
        Cerr <<
            "Error: user not found in the container.\n"
            "Error: try to login as 'root' instead."
            << Endl;
        return -1;
    }

    auto ret = execvp(exec_argv[0], exec_argv);
    ret = errno;
    Cerr << "Error: exec failed with " << ret << Endl;

    return ret;
}
