import time

import uuid

from library.config import detect_hostname


try:
    from api.heartbeat.client import schedule_report_async
except ImportError:
    schedule_report_async = None


fqdn = detect_hostname()


# currently known fields:
#   transport = raw or ssh
#   user
#   acc_user
#   acc_host
#   streaming = bool
#   timeout = float
#   interactive_cmd = bool
#   api_mode = bool
#   extra_files = list[str]
#   command
#   auth_type = rsa or dss or ecdsa
#   auth_bits = int
#   slot_type
#   slot_info
#   watch_parent = bool
#   width = int
#   height = int
#   forward_agent = bool
#   reverse_forwardings = bool
#   direct_forwardings = bool
#   subsystem

def schedule_report(log, **report):
    report.update(
        timestamp=time.time(),
        host=fqdn,
        uuid=str(uuid.uuid4()),
    )
    try:
        schedule_report_async(name='portoshell-connection', report=report, incremental=True)
    except Exception as e:
        log.warning("failed to schedule heartbeat report: %s", e)
    else:
        log.debug("scheduled report %s", report)
