from infra.skylib.certificates import CertKind


LABELS_MAP = {
    "all": CertKind.Any,
    "insecure_and_secure": CertKind.Insecure | CertKind.Secure,
    "secure": CertKind.Secure,
    "unknown": CertKind.Any,
}


def get_allowed_cert_kind(*auth_labels):
    if not auth_labels:
        return CertKind.Any

    mode = CertKind.Any
    for label in auth_labels:
        mode &= LABELS_MAP.get(label, CertKind.Any)

    return mode


def ssh_keys_allowed(*auth_labels):
    return bool(get_allowed_cert_kind(*auth_labels) & CertKind.SshKey)
