class AuthError(Exception):
    pass


class SlotLookupError(Exception):
    def __init__(self, message, slots):
        self.message = message
        self.slots = slots

    def __str__(self):
        parts = [self.message, 'Candidates are:']
        for slot, confs in self.slots:
            parts.append('   - %s' % (slot,))
            for conf in confs:
                if conf.configuration_id and conf.state:
                    parts.append('      * %s  (%s)' % (conf.configuration_id, conf.state))
        return '\n'.join(parts)


class ConfigurationLookupError(Exception):
    def __init__(self, message, candidates):
        self.message = message
        self.candidates = candidates

    def __str__(self):
        return (self.message +
                '\nCandidates are:\n' +
                '\n'.join('   - %s' % (cand,) for cand in self.candidates))
