class MTNBaseInfoProxy(object):
    __attrs__ = ()

    def __init__(self, slave):
        object.__setattr__(self, '_slave', slave)

    def __getattr__(self, attr):
        return getattr(self._slave, attr)

    def __setattr__(self, attr, val):
        return setattr(self._slave, attr, val)

    def __delattr__(self, attr):
        return delattr(self._slave, attr)

    def __eq__(self, other):
        return type(self) is type(other) and all(
            getattr(self, attr) == getattr(other, attr)
            for attr in self.__attrs__
        )

    def __str__(self):
        return '%s(%s)' % (
            type(self).__name__,
            ', '.join('%s=%s' % (attr, getattr(self, attr)) for attr in self.__attrs__)
        )

    def __repr__(self):
        return '%s(%s)' % (
            type(self).__name__,
            ', '.join('%s=%r' % (attr, getattr(self, attr)) for attr in self.__attrs__)
        )


class MTNSlotInfoProxy(MTNBaseInfoProxy):
    __attrs__ = ('slot', 'configuration_id', 'container', 'mtn_hostname', 'mtn_interfaces', 'mtn_slot_container')


class MTNYpLiteSlotInfoProxy(MTNSlotInfoProxy):
    __attrs__ = ('slot', 'configuration_id', 'container', 'mtn_hostname', 'mtn_interfaces', 'mtn_slot_container')


class MTNPodInfoProxy(MTNBaseInfoProxy):
    __attrs__ = ('pod', 'box', 'container', 'mtn_hostname', 'mtn_interfaces', 'mtn_slot_container')
