import os
import fcntl
from cStringIO import StringIO


class Fd(int):
    def __del__(self):
        os.close(self)


def setnonblocking(fd):
    fcntl.fcntl(fd, fcntl.F_SETFL, fcntl.fcntl(fd, fcntl.F_GETFL) | os.O_NONBLOCK)
    return fd


def pipe():
    return tuple(setnonblocking(Fd(fd)) for fd in os.pipe())


def quote_env(v):
    return v.replace(';', r'\;')


def quote_shell_arg(arg):
    result = StringIO()
    result.write("'")
    for char in arg:
        if char == "'":
            result.write("'" '"' "'" '"' "'")
        else:
            result.write(char)
    result.write("'")
    return result.getvalue()


def prepare_env(shell, user, extra_vals=None, unset_vals=None):
    extra_vals = extra_vals or ()
    unset_vals = unset_vals or ()

    env = os.environ.copy()
    if shell:
        env['SHELL'] = shell
    else:
        env.pop('SHELL', None)
    for forbidden in (
        'SUDO_USER',
        'SUDO_UID',
        'SUDO_GID',
        'SUDO_COMMAND',
        'XAUTHORIRY',
        'USER',
        'USERNAME',
        'PYTHONPATH',
        'SSH_AUTH_SOCK',
        'YP_TOKEN',
    ):
        env.pop(forbidden, None)

    for k, v in extra_vals:
        env[k] = v

    env.setdefault('LANG', 'en_US.utf8')
    env.setdefault('LC_ALL', 'en_US.utf8')
    env.setdefault('TERM', 'xterm')
    env.setdefault('USER', user)
    env.setdefault('USERNAME', user)

    for k in unset_vals:
        env.pop(k, None)

    return '; '.join('{}={}'.format(k, quote_env(v)) for k, v in env.iteritems())


def ensure_dir(path):
    if os.path.isdir(path):
        return
    if os.path.exists(path):
        os.unlink(path)
    os.makedirs(path)
