PY2_LIBRARY()

OWNER(torkve)

BUILD_ONLY_IF(LINUX)

PEERDIR(
    infra/portoshell/src/slots

    contrib/python/paramiko
    contrib/python/six
    contrib/python/yappi
    contrib/libs/libcap
    contrib/python/ujson
    infra/porto/api_py
    infra/skylib/certificates
    infra/skylib/debug_server
    infra/skylib/http_tools
    infra/skylib/keys_storage
    infra/skylib/porto
    infra/skylib/safe_container_actions
    library/python/capabilities
    library/python/nstools
    skynet/library
    skynet/kernel
    skynet/api/copier
    skynet/api/heartbeat
    )

SRCDIR(infra/portoshell/src)
ADDINCL(contrib/libs/libcap/include)

PY_SRCS(
    NAMESPACE ya.skynet.services.portoshell
    __init__.py
    authenticate.py
    authsyslog.py
    connserver.py
    daemon.py
    filesystem.pyx
    handlers.py
    heartbeat.py
    logger.py
    portotools.py
    proxy.py
    raw.py
    shell.py
    ssh.py
    sysutils.py
    utils.py
    )

NO_CHECK_IMPORTS()
# SET(NO_STRIP yes)

END()

RECURSE(
    binary
    scp
    sessionleader
    shellwrapper
)
RECURSE_FOR_TESTS(tests)
