import collections
import os

from .kernel_util.functional import singleton

from .utils import Fd, fileno, gread


class MailBox(object):
    def __init__(self):
        pipe = os.pipe()
        self.rpipe = Fd(pipe[0])
        self.wpipe = Fd(pipe[1])
        self.queue = collections.deque()

    def put(self, obj):
        self.queue.append(obj)
        os.write(fileno(self.wpipe), 'c')

    def get(self):
        while not self.queue:
            gread(self.rpipe, 4096)

        return self.queue.popleft()

    def iterate(self):
        while True:
            yield self.get()


@singleton
def mailbox():
    return MailBox()
