from __future__ import print_function

import sys
import os
import time
import subprocess as subproc

from kernel.util.sys.user import UserPrivileges
from kernel.pyro.client import PyroProxy
import api.config

from .check_procman import running


skyroot = sys.argv[1]
server_uri = sys.argv[2]


def _run_daemon(args, env):
    proc = subproc.Popen(
        args, env=env, close_fds=True, stdout=subproc.PIPE, stderr=subproc.PIPE, cwd='/'
    )

    isrunning = False

    while proc.poll() is None and not isrunning:
        try:
            isrunning = running(skyroot, server_uri)
        except Exception:
            isrunning = False
        if not isrunning:
            time.sleep(0.1)

    if not isrunning:
        if proc.poll() is not None:
            print('error: procman process died with exitcode %d' % (proc.poll(), ), file=sys.stderr)
            stdout, stderr = proc.communicate()
            if stderr:
                print(stderr, file=sys.stderr, end='')
            raise Exception('error: procman process died with exitcode %d' % (proc.poll(), ))
        else:
            assert 0, 'we should not be here'

    elif isrunning:
        assert proc.poll() is None, 'procman died after reported he is running fine!'
        PyroProxy(server_uri, retries=(0,)).closefds()
        for stream in proc.stdout, proc.stderr:
            stream.close()
        while proc.poll() is None:
            time.sleep(1)


def main():
    args = [
        os.path.normpath(os.path.abspath('bin/procman')),
        '--appdir', os.path.abspath(''),
        '--workdir', os.path.join(skyroot, 'var', 'procman'),
        '--logdir', os.path.join(skyroot, 'var', 'log'),
        '--lock_port', str(10004 + api.config.basePortOffset()),
    ]

    env = {}
    for key, value in os.environ.items():
        if (
            key.startswith('SKYNET') or
            key in ('PYTHONPATH', 'PYTHON',)
        ):
            env[key] = value

    # TODO: drop /Berkanavt/bin/scripts?  # noqa
    env['PATH'] = '/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin:/Berkanavt/bin/scripts'
    env['TMPDIR'] = '/var/tmp'

    try:
        with UserPrivileges():
            _run_daemon(args, env)
    except EnvironmentError as ex:
        import errno
        if ex.errno != errno.EPERM:
            raise
        _run_daemon(args, env)
