#include <infra/proto_logger/libs/main/main.h>

#include <library/cpp/getopt/small/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char** argv) {
    TModChooser modChooser;

    modChooser.AddMode("run",
                       NProtoLogger::RunMain,
                       "Run proto_logger daemon.");

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
