#include "logger.h"

namespace NProtoLogger {
    TLogger::TLogger(const TLoggerConfig& config)
        : Config_(config)
    {
    }

    void TLogger::OpenLogs(const TVector<TString>& logNames) {
        for (const auto& logName: logNames) {
            Logs_.insert({logName, TLog(CreateOwningThreadedLogBackend(logName, 0))});
        }
    }

    const TLog& TLogger::Log(const TString& logName) const noexcept {
        return Logs_.at(logName);
    }

    void TLogger::ReopenLog(const TString& logName) {
        Logs_.at(logName).ReopenLog();
    }

    void TLogger::ReopenLogs() {
        for (auto& [logName, log]: Logs_) {
            Y_UNUSED(logName);
            log.ReopenLog();
        }
    }

    size_t TLogger::MaxLoggingQueueSize() const noexcept {
        size_t result = 0;
        for (const auto& [logName, log]: Logs_) {
            Y_UNUSED(logName);
            result = std::max(result, log.BackEndQueueSize());
        }
        return result;
    }

    bool TLogger::IsLoggingQueueFull() const noexcept {
        return MaxLoggingQueueSize() >= Config_.GetMaxQueueSize();
    }

    bool TLogger::IsLoggingQueueFull(const TString& logName) const noexcept {
        return Logs_.at(logName).BackEndQueueSize() >= Config_.GetMaxQueueSize();
    }
}
