#pragma once

#include <infra/proto_logger/libs/logger/config.pb.h>
#include <library/cpp/logger/log.h>
#include <util/generic/hash.h>
#include <util/generic/vector.h>

namespace NProtoLogger {
    class TLogger {
    public:
        TLogger(const TLoggerConfig& config);

        void OpenLogs(const TVector<TString>& logNames);

        const TLog& Log(const TString& logName) const noexcept;

        void ReopenLog(const TString& logName);

        void ReopenLogs();

        size_t MaxLoggingQueueSize() const noexcept;

        bool IsLoggingQueueFull() const noexcept;

        bool IsLoggingQueueFull(const TString& logName) const noexcept;

    private:
        TLoggerConfig Config_;
        THashMap<TString, TLog> Logs_;
    };
}
