#include "main.h"

#include <infra/proto_logger/libs/config/config.pb.h>
#include <infra/proto_logger/libs/service/service.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>
#include <library/cpp/protobuf/json/proto2json.h>

namespace NProtoLogger {
    namespace {
        void PrettyPrintConfig(const TProtoLoggerConfig& config) {
            NJson::TJsonValue configJson;
            TStringStream str{NProtobufJson::Proto2Json(config)};
            Cout << NJson::WriteJson(NJson::ReadJsonTree(&str, /* allowComments */ false, /* throwOnError */ true), /* formatOutput */ true) << Endl;
        }

        int RunMain(const TProtoLoggerConfig& config) {
            PrettyPrintConfig(config);

            TService service(config);

            service.Start();
            service.Wait();

            return 0;
        }

    } // end of anonymous namespace

    int RunMain(NProtoConfig::TLoadConfigOptions& options) {
        const auto cfg = NProtoConfig::LoadWithOptions<TProtoLoggerConfig>(options);
        return RunMain(cfg);
    }

    int RunMain(int argc, const char* argv[]) {
        const auto cfg = NProtoConfig::GetOpt<TProtoLoggerConfig>(argc, argv, "/proto_logger/proto_config.json");
        return RunMain(cfg);
    }
}
