#pragma once

#include <infra/libs/service_iface/router.h>

#include <infra/proto_logger/libs/config/config.pb.h>
#include <infra/proto_logger/libs/service_iface/api.h>

#include <util/generic/flags.h>

namespace NProtoLogger {
    enum class EHandlerTypeFlag {
        NONE       = 0 /* "none" */,
        PROTO      = 1 /* "/write" */,
        JSON       = 2 /* "/write/json" */,
        JSON_BATCH = 4 /* "/write/json/batch" */,
        ALL        = 7 /* "all" */,
    };

    Y_DECLARE_FLAGS(EHandlerType, EHandlerTypeFlag)
    Y_DECLARE_OPERATORS_FOR_FLAGS(EHandlerType)

    TString BuildClientPath(const TString& clientName, EHandlerTypeFlag handlerType);

    template<typename TReq>
    void AddClientRoutes(TSimpleSharedPtr<NInfra::TRequestRouter<NProtoLogger::IApi>> router,
                         const TString& client,
                         EHandlerType handlerTypes);

    NInfra::TRequestRouterPtr CreateRouter(IApi& service, const TProtoLoggerConfig& config);
}
